<?php

class Notifikasi
{
    protected $ci;

    function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model('notifikasi_kasir');
        $this->ci->load->model('notifikasi_manager');
        $this->ci->load->model('notifikasi_keuangan');
        $this->ci->load->model('notifikasi_owner');
        $this->ci->load->model('notif_kabag_marketing');
    }
    public function notif_owner()
    {
        $notif = array(
            'verif_heboh' => $this->ci->notifikasi_owner->nv_verifheboh(),
            'verif_motor' => $this->ci->notifikasi_owner->nv_verifmotor()
        );
        return $notif;
    }
    public function notif_manager()
    {
        $notif = array(
            'verif_heboh' => $this->ci->notifikasi_manager->nv_verifheboh(),
            'verif_motor' => $this->ci->notifikasi_manager->nv_verifmotor()
        );
        return $notif;
    }
    public function notif_keuangan()
    {
        $notif = array(
            'verif_heboh' => $this->ci->notifikasi_keuangan->nv_verifheboh(),
            'verif_motor' => $this->ci->notifikasi_keuangan->nv_verifmotor()
        );
        return $notif;
    }
    public function notif_kasir()
    {
        $notif = array(
            'notif_heboh'     => $this->ci->notifikasi_kasir->nv_arisanheboh(),
            'notif_motor'     => $this->ci->notifikasi_kasir->nv_arisanmotor(),
            'notif_motor_tunggakan'     => $this->ci->notifikasi_kasir->nv_arisanmotor_tunggakan(),
            'notif_realisasi' => $this->ci->notifikasi_kasir->nv_realisasi(),
            'angs_mingguan'   => $this->ci->notifikasi_kasir->nv_angs_mingguan(),
            'angs_2mingguan'  => $this->ci->notifikasi_kasir->nv_angs_2mingguan(),
            'angs_bulanan'    => $this->ci->notifikasi_kasir->nv_angs_bulanan(),
            'angs_musiman'    => $this->ci->notifikasi_kasir->nv_angs_musiman(),
            'angs_abulanan'   => $this->ci->notifikasi_kasir->nv_angs_abulanan(),
            'angs_kbulanan'   => $this->ci->notifikasi_kasir->nv_angs_kbulanan()
        );
        return $notif;
    }
    public function notif_kabag_marketing()
    {
        $notif = array(
            'verif_pengajuan' => $this->ci->notif_kabag_marketing->nv_pengajuan(),
            'verif_kasir'     => $this->ci->notif_kabag_marketing->nv_kasir()
        );
        return $notif;
    }
}
